﻿using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.Common;
using System;
using System.Linq;

namespace WPF.PresentationLayer.UC115.ViewModels
{
    public class PatientSelectionItemViewModel : NotifyPropertyChanged
    {
        private PatientWithPendingSpecimenTestModel _patientWithSpecimen;
        /// <summary>
        /// PatientWithPendingSpecimenTestModel
        /// </summary>
        public PatientWithPendingSpecimenTestModel PatientWithSpecimen
        {
            get
            {
                return _patientWithSpecimen;
            }
            set
            {
                _patientWithSpecimen = value;
                RaisePropertyChanged(() => PatientWithSpecimen);
            }
        }

        /// <summary>
        /// Patient Guid
        /// </summary>
        public Guid PatientGuid { get { return PatientWithSpecimen.Patient.PatientGuid; } }
                
        //public IList<OrderableTestModel> OrderableTestNameList { get; private set; }

        public string OrderableTestNameListFormattedPropName = "OrderableTestNameListFormatted";
        /// <summary>
        /// Comma delimintated list of Test names (ordered by name)
        /// </summary>
        public string OrderableTestNameListFormatted
        {
            get
            {
                if (PatientWithSpecimen.OrderableTestList == null)
                {
                    return "";
                }
                else
                {
                    return string.Join(", ", PatientWithSpecimen.OrderableTestList.Select(x => x.DisplayName)
                                                                                  .OrderBy(o => o)
                                                                                  .ToArray());
                }
            }
        }

        /// <summary>
        /// Formatted Gender/Sex
        /// </summary>
        public string DisplaySex
        {
            get
            {
                if (PatientWithSpecimen.Patient.Sex != Sex.Unknown)
                {
                    return PatientWithSpecimen.Patient.Sex.ToString();
                }

                return "";
            }
        }

        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="patientWithPendingSpecimenTestModel"></param>
        public PatientSelectionItemViewModel(PatientWithPendingSpecimenTestModel patientWithPendingSpecimenTestModel)
        {
            if (patientWithPendingSpecimenTestModel == null) throw new ArgumentNullException("patientWithPendingSpecimenTestModel");
            if (patientWithPendingSpecimenTestModel.Patient == null) throw new ArgumentException("PatientWithPendingSpecimenTestModel.Patient cannot be null");
            if (patientWithPendingSpecimenTestModel.OrderableTestList == null) throw new ArgumentException("PatientWithPendingSpecimenTestModel.OrderableTestNameList cannot be null");

            //OrderableTestNameList = patientWithPendingSpecimenTestModel.OrderableTestList.ToList();
            _patientWithSpecimen = patientWithPendingSpecimenTestModel;
        }
    }
}
